<?php
	//Inclueix l'objecte de la base de dades:	
	require_once "bd_access.php";

	//Objecte que crea una pagina web de una planta:
	class comandes
	{
		//Nom de l'arxiu:
		var $arxiu_nom;
		//Directori de l'arxiu:
		var $arxiu_directori = "generats/";
		//Path de l'arxiu:
		var $arxiu_path;
		//Punter a l'arxiu:
		var $arxiu_punter;
		//Defineix els problemes que poden existir:
		var $problemes = "";
	
		//Constructor
		function comandes()
		{
			$this->arxiu_nom = "pedidos_infprimaria.php";
			//Defineix el path de l'arxiu:
			$this->arxiu_path = $this->arxiu_directori . $this->arxiu_nom;
			//Obre l'arxiu:
			$this->obrir();
			//Crea el contingut de l'arxiu:
			$this->ficar_capsalera();
			$this->ficar_cos();
			$this->ficar_peu();
			//Tanca l'arxiu:
			$this->tancar();
		}
		
		//Obre l'arxiu de la web:
		function obrir()
		{
			$this->arxiu_punter = @fopen($this->arxiu_path, 'w+');
			if (!$this->arxiu_punter) { $this->problemes .= '[L\'arxiu no es pot crear!] '; }
		}
		
		//Fica la capsalera:
		function ficar_capsalera()
		{
			$this->inclueix("lib/html/comandes_capsalera.txt", "capsalera", "");
		}

		//Fica el cos (contingut):
		function ficar_cos()
		{
			//Crea un objecte de base de dades:
			$bd = new base_dades();
			
			//Connecta a la base de dades:
			$bd->connecta();
			
			//Genera la consulta a la base de dades:
			$query_origen = "SELECT * FROM primaria WHERE nom IS NOT NULL OR isbn IS NOT NULL;";
			$dades_origen = $bd->fes_consulta($query_origen);
			
			//Guarda els resultats, formatats en HTML, en una variable:
			$primaria_generat = $this->genera_llibres($dades_origen);

			//Genera la segona consulta:
			$query_origen = "SELECT * FROM secundaria WHERE nom IS NOT NULL OR isbn IS NOT NULL;";
			$dades_origen = $bd->fes_consulta($query_origen);
		
			//Guarda els resultats, formatats en HTML, en una altra variable:
			$secundaria_generat = $this->genera_llibres($dades_origen);
			
			//Guarda el cos que esta en un arxiu en una variable, canvia els metas per les variables i escriu el resultat com a cos de l'arxiu:
			$origen = "lib/html/comandes_cos.txt";
			$arxiu_origen = trim(implode("", @file($origen)));
			$error_escriptura = FALSE;
			if ($arxiu_origen == "") { $this->problemes .= "[No s'ha pogut llegir <b>" . $origen . "</b>] "; }
			else
			{
				$arxiu_origen = str_replace("[GENERAT_PRIMARIA]", $primaria_generat, $arxiu_origen);
				$arxiu_origen = str_replace("[GENERAT_SECUNDARIA]", $secundaria_generat, $arxiu_origen);
				$escrit = @fwrite($this->arxiu_punter, $arxiu_origen);
				if (!$escrit) { $error_escriptura = TRUE; }
				if ($error_escriptura) { $this->problemes .= "[Error d'escriptura de cos (" . $origen . ") en l'arxiu.] "; }
			}
			
			//Desconecta de la base de dades:
			$bd->desconnecta();
		}

		//Genera el codi de cada llibre i el retorna en una variable de text:
		function genera_llibres($dades_origen)
		{
			$codi_generat = $codi_calculat = "";
			$tancar_titol = FALSE;
			while (odbc_fetch_row($dades_origen))
			{
				$tipus = trim(odbc_result($dades_origen, "tipus"));
				$isbn = trim(odbc_result($dades_origen, "isbn"));
				$nom = trim(odbc_result($dades_origen, "nom"));
				$preu = trim(odbc_result($dades_origen, "preu"));
				$preu_iva = trim(odbc_result($dades_origen, "preu_iva"));
				$hi_ha_subtitol = FALSE;
				//Si solament te nom, es un titol:
				if ($nom != "" && $tipus == "" && $isbn == "" && $preu == "" && $preu_iva == "")
				{
					//echo '<h2>Titol: ' . $nom . '</h2>';
					/* 	<TR><TD colspan=2><img src="../images/puntsb.gif"></TD></TR>
						<TR bgcolor="#799D0C">
							<TD colspan=3>
								<FONT COLOR="FFFFFF">&nbsp;&nbsp;<B>ESO MATEMTIQUES */
					$codi_calculat .= '<TR><TD colspan=2><img src="../images/puntsb.gif"></TD></TR>';
					$codi_calculat .= '<TR bgcolor="#6198AB"><TD colspan=3><FONT COLOR="FFFFFF">&nbsp;&nbsp;<B>' . $nom;
					$tancar_titol = TRUE;
					$hi_ha_subtitol = TRUE;
				}
				//...pero si es un subtitol:
				else if (strtolower($tipus) == "s" && $nom != "")
				{
					//echo '<h3>Subtitol: ' . $nom . '</h3>';
					$codi_calculat .= " $nom";
					$codi_calculat .= '</TD><TD></TD></TR><TR><TD colspan=3><img src="../images/puntsb.gif"></TD></TR>';
					$tancar_titol = FALSE;
					$hi_ha_subtitol = TRUE;
				}
				//...pero si es un subapartat:
				else if (strtolower($tipus) == "sa" && ($nom != "" || $isbn != ""))
				{
					if ($isbn != "" && $nom == "") { $nom = $isbn; }
					//echo '<h4>Sub-apartat: ' . $nom . '</h4>';
					/* <TR>
					<TD colspan=3>
						<FONT COLOR="#799D0C"><b>Srie 0:  Habilitats motrius.  Iniciaci a la lectura i l'escriptura</b></FONT> 
					</TD></TR> 
					<TR><TD colspan=3><img src="../images/puntsb.gif"></TD>
					</TR>*/
					$codi_calculat .= '<TR><TD colspan=3><FONT COLOR="#6198AB"><b>' . $nom . '</b></FONT></TD></TR><TR><TD colspan=3><img src="../images/puntsb.gif"></TD></TR>';
					$hi_ha_subtitol = FALSE;
				}
				//...pero si es un llibre:
				else if ($isbn != ""  && $nom != "" && $preu != "" && $preu_iva != "")
				{
					//echo '<h5>Llibre: ' . $nom . ' (' . $preu . ' [' . $preu_iva . ']), [' . $isbn . ']</h5>';
					//Aplicar number_format($preu[_iva], 2)!!!
					/* <TR><TD colspan=3><img src="../images/puntsv.gif"></TD></TR>
					<TR>
					<TD>
						N 1 Nombres enters
					</TD>
					<TD>1,54</TD>
					<TD>1,60</TD>
					</TR> */
					$codi_calculat .= '<TR><TD>'.$nom.'</TD><TD><INPUT value="" NAME="'  . "_" . addslashes(strtolower(str_replace(" ", "_", $nom))) . addslashes(strtolower(str_replace(" ", "_", $isbn))) . '" TYPE="TEXT" maxlength="6" size="5" ALIGN=left></TD></TR><TR><TD colspan=3><img src="../images/punts.gif"></TD></TR>';
					$hi_ha_subtitol = FALSE;
				}
				//else { echo "<br><br><br>$nom<br><br><br>"; }
				if ($tancar_titol && !$hi_ha_subtitol)
				{
					$codi_generat .= '</TD><TD></TD></TR><TR><TD colspan=3><img src="../images/puntsb.gif"></TD></TR>' . $codi_calculat;
					$tancar_titol = FALSE;
					$hi_ha_subtitol = FALSE;
				}
				else { $codi_generat .= $codi_calculat; }
				$codi_calculat = "";
			}
			//echo $codi_generat;
			return $codi_generat;
		}
		
		//Fica el peu de pagina:
		function ficar_peu()
		{
			$this->inclueix("lib/html/comandes_peu.txt", "peu");
		}
		
		//Inclueix un arxiu en un altre:
		function inclueix($origen, $nom_origen)
		{
			$error_escriptura = FALSE;
			$arxiu_origen = @file($origen);
			if (!is_array($arxiu_origen)) { $this->problemes .= "[No s'ha pogut llegir <b>" . $origen . "</b>] "; }
			else
			{
				foreach ($arxiu_origen as $linia)
				{
					//if (is_array($navegador))
					//{
						//$linia = str_replace("[ANTERIOR]", $navegador["anterior"], $linia);
						//$linia = str_replace("[SEGUENT]", $navegador["seguent"], $linia);
					//}
					$escrit = @fwrite($this->arxiu_punter, $linia);
					if (!$escrit) { $error_escriptura = TRUE; }
				}
				if ($error_escriptura) { $this->problemes .= "[Error d'escriptura de " . $nom_origen . " (" . $origen . ") en l'arxiu.] "; }
			}
		}
		
		//Tanca l'arxiu de la web:
		function tancar()
		{
			$arxiu_tancat = @fclose($this->arxiu_punter);
			if (!$arxiu_tancat) { $this->problemes .= "[No s'ha pogut tancar l'arxiu] "; }
		}
	}
?>